#include "AneuMeshLoader.h"
#include <fstream>
#include "Exceptions.h"

void AneuMeshLoader::loadMesh(const std::string& fileName) 
{
    size_t nodeNumber, dimension, elementNumber, nodesInElement, boundaryNumber, nodesInBoundary;
    std::ifstream inputFile(fileName);
    if (!inputFile)
        throw Exceptions();

    //   ()   
    inputFile >> nodeNumber >> dimension;
    VectorOfNodes.reserve(nodeNumber);
    for (int i = 1; i <= nodeNumber; ++i) 
    {

        Node temp_node;
        temp_node.NodeId = i;
        inputFile 
            >> temp_node.coordinates[0] 
            >> temp_node.coordinates[1] 
            >> temp_node.coordinates[2];
        temp_node.isVertex = true;
        VectorOfNodes.push_back(temp_node); 
    }

    //    ()        ()
    inputFile >> elementNumber >> nodesInElement;
    VectorOfFE.reserve(elementNumber);
    for (int i = 1; i <= elementNumber; ++i) 
    {
        FiniteElement temp_FE;
        temp_FE.FEId = i;
        inputFile >> temp_FE.MaterialId;
        temp_FE.FiniteElementIdList.reserve(nodesInElement);
        int temp_id;
        for (int j = 0; j < nodesInElement; ++j)
        {
            inputFile >> temp_id;
            temp_FE.FiniteElementIdList.push_back(temp_id);
        }
        VectorOfFE.push_back(std::move(temp_FE));
    }

    //     ,      ( 3-   - 3)
    inputFile >> boundaryNumber >> nodesInBoundary;
    VectorOfBFE.reserve(boundaryNumber);
    for (int i = 1; i <= boundaryNumber; ++i) 
    {
        BoundaryFiniteElement temp_BFE;
        temp_BFE.BFEId = i;
        inputFile >> temp_BFE.boundaryId;
        temp_BFE.FiniteElementIdList.reserve(nodesInBoundary);
        int temp_id;
        for (int j = 0; j < nodesInBoundary; ++j)
        {
            inputFile >> temp_id;
            temp_BFE.FiniteElementIdList.push_back(temp_id);
        }

        std::vector<FiniteElement> temp_FiniteElements = getFiniteElementsById(
            temp_BFE.FiniteElementIdList[0],
            temp_BFE.FiniteElementIdList[1],
            temp_BFE.FiniteElementIdList[2]);

        temp_BFE.FEId = temp_FiniteElements[0].FEId;
        temp_BFE.MaterialId = temp_FiniteElements[0].MaterialId;
        VectorOfBFE.push_back(std::move(temp_BFE));

    }
    inputFile.close();
    std::cout << "Data loaded successfully" << std::endl;
}